/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package Chapter11.ordering;

import java.time.*;
import static java.time.Month.*;
import static java.time.temporal.ChronoUnit.HOURS;
import java.util.*;
import Chapter11.map.*;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class DataSource {
    //A collection of various instances
    public Map<String,Person> people = new TreeMap<>();
    public Map<String,Meeting> meetings = new HashMap<>();
    //The schedule collection
    public Map<LocalDate,Meeting> mySchedule = new HashMap<>();
    
    public DataSource(){

        //Populate the data source.  We will do this explicity
        //but we could equally create the instances from a database or file.
        
        //Create people.
        Person me = new Person("Employee", "matthew", "gregory", Year.of(1971).atMonth(JULY).atDay(28));
        me.timezone = ZoneId.of("Australia/Sydney");
        Person myCustomer = new Person("Customer", "John", "Smith", LocalDate.now().withYear(1998));
        myCustomer.timezone = ZoneId.of("America/New_York");
        Person myCollegue = new Person("Employee", "Penny", "Chan", LocalDate.now().withYear(1976));
        myCollegue.timezone = ZoneId.of("Australia/Perth");
        //Add them to our people Map
        people.put(me.getFullName(),me);
        people.put(myCustomer.getFullName(),myCustomer);
        people.put(myCollegue.getFullName(),myCollegue);

        //Create meetings
        Meeting myMeeting = new Meeting(me, LocalDateTime.now().plusDays(7).truncatedTo(HOURS));
        myMeeting.agendaItems.add("Discuss Design"); 
        myMeeting.agendaItems.add("Agree on Design");
        myMeeting.agendaItems.add("Document the agreement and prepare design for publishing.");
        Meeting initialMeeting = new Meeting(me,myCustomer);
        Collections.addAll(initialMeeting.agendaItems,"Introductions.","Needs Analysis","Closure");
        Meeting internalMeeting = new Meeting(me,myCollegue);
        Collections.addAll(internalMeeting.agendaItems,"Discuss Needs Analysis","Propose Design","Calculate Proposed Budget");
        Meeting followupMeeting = new Meeting(me,myCollegue,myCustomer);
        Collections.addAll(followupMeeting.agendaItems,"Introductions.","Suggest Design","Provide Quote","Further Questions");
        initialMeeting.meetingDate = LocalDateTime.of(2020, MARCH, 20, 10, 00).atZone(me.timezone);
        internalMeeting.meetingDate = LocalDateTime.of(2020, MARCH, 27, 14, 00).atZone(me.timezone);
        followupMeeting.meetingDate = LocalDateTime.of(2020, APRIL, 5, 9, 00).atZone(me.timezone);
        //Add them to our map
        meetings.put("myMeeting",myMeeting);
        meetings.put("initialMeeting",initialMeeting);
        meetings.put("internalMeeting",internalMeeting);
        meetings.put("followupMeeting",followupMeeting);
        
        //Add meetings to the schedule.
        mySchedule.put(initialMeeting.meetingDate.toLocalDate(),initialMeeting);
        mySchedule.put(internalMeeting.meetingDate.toLocalDate(),internalMeeting);
        mySchedule.put(followupMeeting.meetingDate.toLocalDate(),followupMeeting);

    }    
}
